﻿using AZVIC.Ei8htPOS.BAL;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace AZVIC.Ei8htPOS.POSRetail.Controls
{
    /// <summary>
    /// Interaction logic for SelectSize.xaml
    /// </summary>
    public partial class SelectSize : Window
    {
        string _ProductName { get; set; }
        Guid ProductID { get; set; }
        static Guid ItemID { get; set; }
        public SelectSize(string ProductName,Guid ProductID)
        {
            InitializeComponent();
            this.Loaded += new RoutedEventHandler(PromptDialog_Loaded);
            _ProductName = ProductName;

        }

        void PromptDialog_Loaded(object sender, RoutedEventArgs e)
        {
            List<Products> Productsizes = (from a in AppSession.ProductsList
                                           where a.ProductName == _ProductName
                                           select a).OrderBy(a=>a.SequenceNo).ToList();
            //List<Products> ProductSizes = AppSession.ProductsList.Where(a => a.ProductName == _ProductName).ToList();
            //ProductSizes = ProductSizes.;

    //        from category in categories
    //join prod in products on category.ID equals prod.CategoryID
    //select new { ProductName = prod.Name, Category = category.Name }

            List<ProductMeasurement> Measurements = ProductMeasurementBL.GetList(Guid.Empty, string.Empty);
            if (Measurements != null && Measurements.Count > 0)
            {
                Measurements = Measurements.Where(a => a.IsActive).ToList<ProductMeasurement>();
            }
            List<ProductsXMeasurements> OtherSizes = ProductsXMeasurementBL.GetList(Guid.Empty, ProductID);
            if (OtherSizes != null && OtherSizes.Count > 0)
            {
                OtherSizes = OtherSizes.Where(a => a.IsActive).ToList<ProductsXMeasurements>();
            }

            var DifferentSize = (from sizes in Measurements
                                 join product in Productsizes on sizes.UniqueID equals product.ProductMeasurementID
                                 select new { ProductID = product.UniqueID, SizeName = sizes.MeasurementName, SequenceNo = sizes.SequenceNo , IsDummySize = false , DummySizeID = Guid.Empty }).OrderBy(a => a.SequenceNo).ToList();
                                ;
                                if (OtherSizes != null && OtherSizes.Count > 0)
                                {
                                    foreach (var i in OtherSizes)
                                    {
                                        DifferentSize.Add(new { ProductID = i.ProductID, SizeName = i.TargetSizeName, SequenceNo = DifferentSize.Count, IsDummySize = true , DummySizeID = i.ProductsXMeasurementID });
                                    }
                                    
                                } 

                                icSizes.ItemsSource = DifferentSize;
        }

        public static string Prompt(string productName,Guid ProductID)
        {
            SelectSize inst = new SelectSize(productName,ProductID);
            inst.ShowDialog();
            if (inst.DialogResult == true)
                return inst.ResponseText;
            return null;
        }
        public string ResponseText
        {
            get
            {
                return lblHiddenText.Text;
            }
        }

        private void btnAddToCart_Click(object sender, RoutedEventArgs e)
        {
            dynamic dtsource = (sender as Button).DataContext as dynamic;
            bool IsDummySize = dtsource.IsDummySize;
            if(IsDummySize)
                lblHiddenText.Text = string.Format("{0}|{1}", (sender as Button).Tag, dtsource.DummySizeID);
            else
            lblHiddenText.Text = (sender as Button).Tag.ToString();
            DialogResult = true;
            Close();
        }

        private void btnCancel_Click(object sender, RoutedEventArgs e)
        {
            DialogResult = false;
            Close();
        }
    }
}
